/**
 * \file: mspin_demo_timer.cpp
 *
 * \version: $Id:$
 *
 * \release: $Name:$
 *
 * MySpin
 *
 * \component: MSPIN
 *
 * \author: Bui Le Thuan / thuan.buile@vn.bosch.com
 *          Thilo Bjoern Fickel ICT-ADITG/SW2 tfickel@de.adit-jv.com
 *
 * \copyright: (c) 2003 - 2013 ADIT Corporation
 *
 * \history
 * 0.1 TFickel Initial version
 *
 ***********************************************************************/

#include <mspin_demo_timer.h>
#include <mspin_logging.h>
#include <signal.h>
#include <sys/time.h> //for 'gettimeofday'

#define MSPIN_DEMO_TIMER_CLOCK_ID CLOCK_REALTIME
#define MSPIN_DEMO_TIMER_SIG SIGRTMIN


DemoTimer::DemoTimer()
{

}

DemoTimer::~DemoTimer()
{

}

timer_t DemoTimer::timer_start(mspin_demo_timer_handler handler, unsigned int seconds,
        unsigned int mseconds)
{
    timer_t id = NULL;
    struct itimerspec iTimerSpec;
    struct sigaction timerAction;
    struct sigevent timerEvent;

    mspin_log_printLn(eMspinVerbosityVerbose, "%s(handler=%p, %ds, %dms)",
                __FUNCTION__, handler, seconds, mseconds);

    //Establish handler for timer signal
    timerAction.sa_flags = SA_SIGINFO;
    timerAction.sa_sigaction = handler;
    sigemptyset(&timerAction.sa_mask);

    sigemptyset(&timerAction.sa_mask);
    if (-1 == sigaction(MSPIN_DEMO_TIMER_SIG, &timerAction, NULL))
    {
        mspin_log_printLn(eMspinVerbosityError,
                "%s(handler=%p, %ds, %dms) ERROR: Failed to establish timer action",
                __FUNCTION__, handler, seconds, mseconds);
        return NULL;
    }

    //Create timer
    timerEvent.sigev_notify = SIGEV_SIGNAL;
    timerEvent.sigev_signo = MSPIN_DEMO_TIMER_SIG;
    timerEvent.sigev_value.sival_ptr = NULL;

    if (-1 == timer_create(MSPIN_DEMO_TIMER_CLOCK_ID, &timerEvent , &id))
    {
        mspin_log_printLn(eMspinVerbosityError,
                "%s(handler=%p, %ds, %dms) ERROR: Failed to create timer",
                __FUNCTION__, handler, seconds, mseconds);
        return NULL;
    }

    mspin_log_printLn(eMspinVerbosityDebug,
            "%s(handler=%p, %ds, %dms) timerId=0x%1x",
            __FUNCTION__, handler, seconds, mseconds, (long)id);

    //Start the timer
    iTimerSpec.it_value.tv_sec = (__time_t)seconds;
    iTimerSpec.it_value.tv_nsec = (long int)mseconds*1000*1000; //nano seconds
    iTimerSpec.it_interval.tv_sec = 0; //no interval
    iTimerSpec.it_interval.tv_nsec = 0; //no interval

    if (-1 == timer_settime(id, 0, &iTimerSpec, NULL))
    {
        mspin_log_printLn(eMspinVerbosityError,
                "%s(handler=%p, %ds, %dms) ERROR: Failed to start timer",
                __FUNCTION__, handler, seconds, mseconds);
        return NULL;
    }

    return id;
}

void DemoTimer::timer_stop(timer_t id)
{
    if (id)
    {
        mspin_log_printLn(eMspinVerbosityDebug, "%s(id=0x%1x)",
            __FUNCTION__, (long)id);
        timer_delete(id);
    }
    else
    {
        mspin_log_printLn(eMspinVerbosityDebug, "%s(id=%d) ERROR: id not valid",
            __FUNCTION__, (long)id);
    }
}
